/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.glu.mipmap;

import com.jogamp.common.nio.Buffers;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;
import jogamp.opengl.glu.mipmap.BuildMipmap;
import jogamp.opengl.glu.mipmap.Image;
import jogamp.opengl.glu.mipmap.PixelStorageModes;
import jogamp.opengl.glu.mipmap.ScaleInternal;

public class Mipmap {
    public static int computeLog(int n) {
        int n2 = 0;
        if (n == 0) {
            return -1;
        }
        while (true) {
            if ((n & 1) >= 1) {
                if (n != 1) {
                    return -1;
                }
                return n2;
            }
            n >>= 1;
            ++n2;
        }
    }

    public static int nearestPower(int n) {
        int n2 = 1;
        if (n == 0) {
            return -1;
        }
        while (n != 1) {
            if (n == 3) {
                return n2 * 4;
            }
            n >>= 1;
            n2 *= 2;
        }
        return n2;
    }

    public static short GLU_SWAP_2_BYTES(short s) {
        byte by = 0;
        by = (byte)(s >>> 8);
        s = (short)(s << 8);
        s = (short)(s | 0xFF & by);
        return s;
    }

    public static int GLU_SWAP_4_BYTES(int n) {
        int n2 = n << 24;
        n2 |= 0xFF0000 & n << 8;
        n2 |= 0xFF00 & n >>> 8;
        return n2 |= 0xFF & n >>> 24;
    }

    public static float GLU_SWAP_4_BYTES(float f) {
        int n = Float.floatToRawIntBits(f);
        float f2 = Float.intBitsToFloat(n);
        return f2;
    }

    public static int checkMipmapArgs(int n, int n2, int n3) {
        if (!Mipmap.legalFormat(n2) || !Mipmap.legalType(n3)) {
            return 100900;
        }
        if (n2 == 6401) {
            return 100900;
        }
        if (!Mipmap.isLegalFormatForPackedPixelType(n2, n3)) {
            return 100904;
        }
        return 0;
    }

    public static boolean legalFormat(int n) {
        switch (n) {
            case 6400: 
            case 6401: 
            case 6402: 
            case 6403: 
            case 6404: 
            case 6405: 
            case 6406: 
            case 6407: 
            case 6408: 
            case 6409: 
            case 6410: 
            case 32992: 
            case 32993: {
                return true;
            }
        }
        return false;
    }

    public static boolean legalType(int n) {
        switch (n) {
            case 5120: 
            case 5121: 
            case 5122: 
            case 5123: 
            case 5124: 
            case 5125: 
            case 5126: 
            case 6656: 
            case 32818: 
            case 32819: 
            case 32820: 
            case 32821: 
            case 33634: 
            case 33635: 
            case 33636: 
            case 33637: 
            case 33638: 
            case 33639: 
            case 33640: 
            case 36342: {
                return true;
            }
        }
        return false;
    }

    public static boolean isTypePackedPixel(int n) {
        assert (Mipmap.legalType(n));
        return n == 32818 || n == 33634 || n == 33635 || n == 33636 || n == 32819 || n == 33637 || n == 32820 || n == 33638 || n == 32821 || n == 33639 || n == 36342 || n == 33640;
    }

    public static boolean isLegalFormatForPackedPixelType(int n, int n2) {
        if (Mipmap.isTypePackedPixel(n2)) {
            return true;
        }
        if ((n2 == 32818 || n2 == 33634 || n2 == 33635 || n2 == 33636) & n != 6407) {
            return false;
        }
        return n2 != 32819 && n2 != 33637 && n2 != 32820 && n2 != 33638 && n2 != 32821 && n2 != 33639 && n2 != 36342 && n2 != 33640 || n == 6408 || n == 32993;
    }

    public static boolean isLegalLevels(int n, int n2, int n3, int n4) {
        return n2 >= 0 && n2 >= n && n3 >= n2 && n4 >= n3;
    }

    public static void closestFit(GL gL, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2) {
        if (Double.parseDouble(gL.glGetString(7938).trim().substring(0, 3)) >= 1.1) {
            int n7 = Mipmap.nearestPower(n2);
            int n8 = Mipmap.nearestPower(n3);
            int[] nArray3 = new int[1];
            boolean bl = false;
            try {
                do {
                    int n9;
                    int n10;
                    int n11 = n2 > 1 ? n7 >> 1 : n7;
                    int n12 = n10 = n3 > 1 ? n8 >> 1 : n8;
                    assert (n11 > 0);
                    assert (n10 > 0);
                    if (n == 3553 || n == 32868) {
                        n9 = 32868;
                        gL.glTexImage2D(n9, 1, n4, n11, n10, 0, n5, n6, null);
                    } else if (n == 34069 || n == 34070 || n == 34071 || n == 34072 || n == 34073 || n == 34074) {
                        n9 = 34075;
                        gL.glTexImage2D(n9, 1, n4, n11, n10, 0, n5, n6, null);
                    } else {
                        assert (n == 3552 || n == 32867);
                        n9 = 32867;
                        gL.getGL2GL3().glTexImage1D(n9, 1, n4, n11, 0, n5, n6, null);
                    }
                    if (gL.isGL2GL3()) {
                        gL.getGL2GL3().glGetTexLevelParameteriv(n9, 1, 4096, nArray3, 0);
                    } else {
                        nArray3[0] = 0;
                    }
                    if (nArray3[0] != 0) continue;
                    if (n7 == 1 && n8 == 1) {
                        bl = true;
                        break;
                    }
                    n7 = n11;
                    n8 = n10;
                } while (nArray3[0] == 0);
            }
            catch (GLException gLException) {
                bl = true;
            }
            if (!bl) {
                nArray[0] = n7;
                nArray2[0] = n8;
                return;
            }
        }
        int[] nArray4 = new int[1];
        gL.glGetIntegerv(3379, nArray4, 0);
        nArray[0] = Mipmap.nearestPower(n2);
        if (nArray[0] > nArray4[0]) {
            nArray[0] = nArray4[0];
        }
        nArray2[0] = Mipmap.nearestPower(n3);
        if (nArray2[0] > nArray4[0]) {
            nArray2[0] = nArray4[0];
        }
    }

    public static void closestFit3D(GL gL, int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray, int[] nArray2, int[] nArray3) {
        int n8 = Mipmap.nearestPower(n2);
        int n9 = Mipmap.nearestPower(n3);
        int n10 = Mipmap.nearestPower(n4);
        int[] nArray4 = new int[1];
        do {
            int n11 = n8 > 1 ? n8 >> 1 : n8;
            int n12 = n9 > 1 ? n9 >> 1 : n9;
            int n13 = n10 > 1 ? n10 >> 1 : n10;
            int n14 = 0;
            assert (n11 > 0);
            assert (n12 > 0);
            assert (n13 > 0);
            if (n == 32879 || n == 32880) {
                n14 = 32880;
                gL.getGL2GL3().glTexImage3D(n14, 1, n5, n11, n12, n13, 0, n6, n7, null);
            }
            if (gL.isGL2GL3()) {
                gL.getGL2GL3().glGetTexLevelParameteriv(n14, 1, 4096, nArray4, 0);
            } else {
                nArray4[0] = 0;
            }
            if (nArray4[0] != 0) continue;
            if (n8 == 1 && n9 == 1 && n10 == 1) {
                nArray3[0] = 1;
                nArray2[0] = 1;
                nArray[0] = 1;
                return;
            }
            n8 = n11;
            n9 = n12;
            n10 = n13;
        } while (nArray4[0] == 0);
        nArray[0] = n8;
        nArray2[0] = n9;
        nArray3[0] = n10;
    }

    public static int elements_per_group(int n, int n2) {
        if (n2 == 32818 || n2 == 33634 || n2 == 33635 || n2 == 33636 || n2 == 32819 || n2 == 33637 || n2 == 32820 || n2 == 33638 || n2 == 32821 || n2 == 33639 || n2 == 36342 || n2 == 33640) {
            return 1;
        }
        switch (n) {
            case 6407: 
            case 32992: {
                return 3;
            }
            case 6410: {
                return 2;
            }
            case 6408: 
            case 32993: {
                return 4;
            }
        }
        return 1;
    }

    public static int bytes_per_element(int n) {
        switch (n) {
            case 5120: 
            case 5121: 
            case 6656: 
            case 32818: 
            case 33634: {
                return 1;
            }
            case 5122: 
            case 5123: 
            case 32819: 
            case 32820: 
            case 33635: 
            case 33636: 
            case 33637: 
            case 33638: {
                return 2;
            }
            case 5124: 
            case 5125: 
            case 5126: 
            case 32821: 
            case 33639: 
            case 33640: 
            case 36342: {
                return 4;
            }
        }
        return 4;
    }

    public static boolean is_index(int n) {
        return n == 6400 || n == 6401;
    }

    public static int image_size(int n, int n2, int n3, int n4) {
        assert (n > 0);
        assert (n2 > 0);
        int n5 = Mipmap.elements_per_group(n3, n4);
        int n6 = n4 == 6656 ? (n + 7) / 8 : Mipmap.bytes_per_element(n4) * n;
        return n6 * n2 * n5;
    }

    public static int imageSize3D(int n, int n2, int n3, int n4, int n5) {
        int n6 = Mipmap.elements_per_group(n4, n5);
        int n7 = Mipmap.bytes_per_element(n5) * n;
        assert (n > 0 && n2 > 0 && n3 > 0);
        assert (n5 != 6656);
        return n7 * n2 * n3 * n6;
    }

    public static void retrieveStoreModes(GL gL, PixelStorageModes pixelStorageModes) {
        int[] nArray = new int[1];
        gL.glGetIntegerv(3317, nArray, 0);
        pixelStorageModes.setUnpackAlignment(nArray[0]);
        gL.glGetIntegerv(3314, nArray, 0);
        pixelStorageModes.setUnpackRowLength(nArray[0]);
        gL.glGetIntegerv(3315, nArray, 0);
        pixelStorageModes.setUnpackSkipRows(nArray[0]);
        gL.glGetIntegerv(3316, nArray, 0);
        pixelStorageModes.setUnpackSkipPixels(nArray[0]);
        gL.glGetIntegerv(3313, nArray, 0);
        pixelStorageModes.setUnpackLsbFirst(nArray[0] == 1);
        gL.glGetIntegerv(3312, nArray, 0);
        pixelStorageModes.setUnpackSwapBytes(nArray[0] == 1);
        gL.glGetIntegerv(3333, nArray, 0);
        pixelStorageModes.setPackAlignment(nArray[0]);
        gL.glGetIntegerv(3330, nArray, 0);
        pixelStorageModes.setPackRowLength(nArray[0]);
        gL.glGetIntegerv(3331, nArray, 0);
        pixelStorageModes.setPackSkipRows(nArray[0]);
        gL.glGetIntegerv(3332, nArray, 0);
        pixelStorageModes.setPackSkipPixels(nArray[0]);
        gL.glGetIntegerv(3329, nArray, 0);
        pixelStorageModes.setPackLsbFirst(nArray[0] == 1);
        gL.glGetIntegerv(3328, nArray, 0);
        pixelStorageModes.setPackSwapBytes(nArray[0] == 1);
    }

    public static void retrieveStoreModes3D(GL gL, PixelStorageModes pixelStorageModes) {
        int[] nArray = new int[1];
        gL.glGetIntegerv(3317, nArray, 0);
        pixelStorageModes.setUnpackAlignment(nArray[0]);
        gL.glGetIntegerv(3314, nArray, 0);
        pixelStorageModes.setUnpackRowLength(nArray[0]);
        gL.glGetIntegerv(3315, nArray, 0);
        pixelStorageModes.setUnpackSkipRows(nArray[0]);
        gL.glGetIntegerv(3316, nArray, 0);
        pixelStorageModes.setUnpackSkipPixels(nArray[0]);
        gL.glGetIntegerv(3313, nArray, 0);
        pixelStorageModes.setUnpackLsbFirst(nArray[0] == 1);
        gL.glGetIntegerv(3312, nArray, 0);
        pixelStorageModes.setUnpackSwapBytes(nArray[0] == 1);
        gL.glGetIntegerv(32877, nArray, 0);
        pixelStorageModes.setUnpackSkipImages(nArray[0]);
        gL.glGetIntegerv(32878, nArray, 0);
        pixelStorageModes.setUnpackImageHeight(nArray[0]);
        gL.glGetIntegerv(3333, nArray, 0);
        pixelStorageModes.setPackAlignment(nArray[0]);
        gL.glGetIntegerv(3330, nArray, 0);
        pixelStorageModes.setPackRowLength(nArray[0]);
        gL.glGetIntegerv(3331, nArray, 0);
        pixelStorageModes.setPackSkipRows(nArray[0]);
        gL.glGetIntegerv(3332, nArray, 0);
        pixelStorageModes.setPackSkipPixels(nArray[0]);
        gL.glGetIntegerv(3329, nArray, 0);
        pixelStorageModes.setPackLsbFirst(nArray[0] == 1);
        gL.glGetIntegerv(3328, nArray, 0);
        pixelStorageModes.setPackSwapBytes(nArray[0] == 1);
        gL.glGetIntegerv(32875, nArray, 0);
        pixelStorageModes.setPackSkipImages(nArray[0]);
        gL.glGetIntegerv(32876, nArray, 0);
        pixelStorageModes.setPackImageHeight(nArray[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int gluScaleImage(GL gL, int n, int n2, int n3, int n4, ByteBuffer byteBuffer, int n5, int n6, int n7, ByteBuffer byteBuffer2) {
        int n8 = byteBuffer.position();
        int n9 = byteBuffer2.position();
        try {
            PixelStorageModes pixelStorageModes = new PixelStorageModes();
            if (n2 == 0 || n3 == 0 || n5 == 0 || n6 == 0) {
                int n10 = 0;
                return n10;
            }
            if (n2 < 0 || n3 < 0 || n5 < 0 || n6 < 0) {
                int n11 = 100901;
                return n11;
            }
            if (!(Mipmap.legalFormat(n) && Mipmap.legalType(n4) && Mipmap.legalType(n7))) {
                int n12 = 100900;
                return n12;
            }
            if (!Mipmap.isLegalFormatForPackedPixelType(n, n4)) {
                int n13 = 100904;
                return n13;
            }
            if (!Mipmap.isLegalFormatForPackedPixelType(n, n7)) {
                int n14 = 100904;
                return n14;
            }
            ByteBuffer byteBuffer3 = Buffers.newDirectByteBuffer((int)Mipmap.image_size(n2, n3, n, 5123));
            ByteBuffer byteBuffer4 = Buffers.newDirectByteBuffer((int)Mipmap.image_size(n5, n6, n, 5123));
            if (byteBuffer3 == null || byteBuffer4 == null) {
                int n15 = 100902;
                return n15;
            }
            Mipmap.retrieveStoreModes(gL, pixelStorageModes);
            Image.fill_image(pixelStorageModes, n2, n3, n, n4, Mipmap.is_index(n), byteBuffer, byteBuffer3.asShortBuffer());
            int n16 = Mipmap.elements_per_group(n, 0);
            ScaleInternal.scale_internal(n16, n2, n3, byteBuffer3.asShortBuffer(), n5, n6, byteBuffer4.asShortBuffer());
            Image.empty_image(pixelStorageModes, n5, n6, n, n7, Mipmap.is_index(n), byteBuffer4.asShortBuffer(), byteBuffer2);
            int n17 = 0;
            return n17;
        }
        finally {
            byteBuffer.position(n8);
            byteBuffer2.position(n9);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int gluBuild1DMipmapLevels(GL gL, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ByteBuffer byteBuffer) {
        int n9 = byteBuffer.position();
        try {
            int n10 = Mipmap.checkMipmapArgs(n2, n4, n5);
            if (n10 != 0) {
                int n11 = n10;
                return n11;
            }
            if (n3 < 1) {
                int n12 = 100901;
                return n12;
            }
            int n13 = Mipmap.computeLog(n3);
            if (!Mipmap.isLegalLevels(n6, n7, n8, n13 += n6)) {
                int n14 = 100901;
                return n14;
            }
            int n15 = BuildMipmap.gluBuild1DMipmapLevelsCore(gL, n, n2, n3, n3, n4, n5, n6, n7, n8, byteBuffer);
            return n15;
        }
        finally {
            byteBuffer.position(n9);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int gluBuild1DMipmaps(GL gL, int n, int n2, int n3, int n4, int n5, ByteBuffer byteBuffer) {
        int n6 = byteBuffer.position();
        try {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            int n7 = Mipmap.checkMipmapArgs(n2, n4, n5);
            if (n7 != 0) {
                int n8 = n7;
                return n8;
            }
            if (n3 < 1) {
                int n9 = 100901;
                return n9;
            }
            Mipmap.closestFit(gL, n, n3, 1, n2, n4, n5, nArray, nArray2);
            int n10 = Mipmap.computeLog(nArray[0]);
            int n11 = BuildMipmap.gluBuild1DMipmapLevelsCore(gL, n, n2, n3, nArray[0], n4, n5, 0, 0, n10, byteBuffer);
            return n11;
        }
        finally {
            byteBuffer.position(n6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int gluBuild2DMipmapLevels(GL gL, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Object object) {
        Object[] objectArray;
        int n10 = 0;
        int n11 = Mipmap.checkMipmapArgs(n2, n5, n6);
        if (n11 != 0) {
            return n11;
        }
        if (n3 < 1 || n4 < 1) {
            return 100901;
        }
        int n12 = Mipmap.computeLog(n3);
        int n13 = Mipmap.computeLog(n4);
        if (n13 > n12) {
            n12 = n13;
        }
        if (!Mipmap.isLegalLevels(n7, n8, n9, n12 += n7)) {
            return 100901;
        }
        ByteBuffer byteBuffer = null;
        if (object instanceof ByteBuffer) {
            byteBuffer = (ByteBuffer)object;
            n10 = byteBuffer.position();
        } else if (object instanceof byte[]) {
            objectArray = (byte[])object;
            byteBuffer = ByteBuffer.allocateDirect(objectArray.length);
            byteBuffer.put((byte[])objectArray);
        } else if (object instanceof short[]) {
            objectArray = (short[])object;
            byteBuffer = ByteBuffer.allocateDirect(objectArray.length * 2);
            ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
            shortBuffer.put((short[])objectArray);
        } else if (object instanceof int[]) {
            objectArray = (int[])object;
            byteBuffer = ByteBuffer.allocateDirect(objectArray.length * 4);
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            intBuffer.put((int[])objectArray);
        } else if (object instanceof float[]) {
            objectArray = (float[])object;
            byteBuffer = ByteBuffer.allocateDirect(objectArray.length * 4);
            FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
            floatBuffer.put((float[])objectArray);
        }
        try {
            int n14 = BuildMipmap.gluBuild2DMipmapLevelsCore(gL, n, n2, n3, n4, n3, n4, n5, n6, n7, n8, n9, byteBuffer);
            return n14;
        }
        finally {
            byteBuffer.position(n10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int gluBuild2DMipmaps(GL gL, int n, int n2, int n3, int n4, int n5, int n6, Object object) {
        Object[] objectArray;
        int n7 = 0;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n8 = Mipmap.checkMipmapArgs(n2, n5, n6);
        if (n8 != 0) {
            return n8;
        }
        if (n3 < 1 || n4 < 1) {
            return 100901;
        }
        Mipmap.closestFit(gL, n, n3, n4, n2, n5, n6, nArray, nArray2);
        int n9 = Mipmap.computeLog(nArray[0]);
        int n10 = Mipmap.computeLog(nArray2[0]);
        if (n10 > n9) {
            n9 = n10;
        }
        ByteBuffer byteBuffer = null;
        if (object instanceof ByteBuffer) {
            byteBuffer = (ByteBuffer)object;
            n7 = byteBuffer.position();
        } else if (object instanceof byte[]) {
            objectArray = (byte[])object;
            byteBuffer = ByteBuffer.allocateDirect(objectArray.length);
            byteBuffer.put((byte[])objectArray);
        } else if (object instanceof short[]) {
            objectArray = (short[])object;
            byteBuffer = ByteBuffer.allocateDirect(objectArray.length * 2);
            ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
            shortBuffer.put((short[])objectArray);
        } else if (object instanceof int[]) {
            objectArray = (int[])object;
            byteBuffer = ByteBuffer.allocateDirect(objectArray.length * 4);
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            intBuffer.put((int[])objectArray);
        } else if (object instanceof float[]) {
            objectArray = (float[])object;
            byteBuffer = ByteBuffer.allocateDirect(objectArray.length * 4);
            FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
            floatBuffer.put((float[])objectArray);
        }
        try {
            int n11 = BuildMipmap.gluBuild2DMipmapLevelsCore(gL, n, n2, n3, n4, nArray[0], nArray2[0], n5, n6, 0, 0, n9, byteBuffer);
            return n11;
        }
        finally {
            byteBuffer.position(n7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int gluBuild3DMipmaps(GL gL, int n, int n2, int n3, int n4, int n5, int n6, int n7, ByteBuffer byteBuffer) {
        int n8 = byteBuffer.position();
        try {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            int n9 = Mipmap.checkMipmapArgs(n2, n6, n7);
            if (n9 != 0) {
                int n10 = n9;
                return n10;
            }
            if (n3 < 1 || n4 < 1 || n5 < 1) {
                int n11 = 100901;
                return n11;
            }
            if (n7 == 6656) {
                int n12 = 100900;
                return n12;
            }
            Mipmap.closestFit3D(gL, n, n3, n4, n5, n2, n6, n7, nArray, nArray2, nArray3);
            int n13 = Mipmap.computeLog(nArray[0]);
            int n14 = Mipmap.computeLog(nArray2[0]);
            if (n14 > n13) {
                n13 = n14;
            }
            if ((n14 = Mipmap.computeLog(nArray3[0])) > n13) {
                n13 = n14;
            }
            int n15 = BuildMipmap.gluBuild3DMipmapLevelsCore(gL, n, n2, n3, n4, n5, nArray[0], nArray2[0], nArray3[0], n6, n7, 0, 0, n13, byteBuffer);
            return n15;
        }
        finally {
            byteBuffer.position(n8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int gluBuild3DMipmapLevels(GL gL, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, ByteBuffer byteBuffer) {
        int n11 = byteBuffer.position();
        try {
            int n12 = Mipmap.checkMipmapArgs(n2, n6, n7);
            if (n12 != 0) {
                int n13 = n12;
                return n13;
            }
            if (n3 < 1 || n4 < 1 || n5 < 1) {
                int n14 = 100901;
                return n14;
            }
            if (n7 == 6656) {
                int n15 = 100900;
                return n15;
            }
            int n16 = Mipmap.computeLog(n3);
            int n17 = Mipmap.computeLog(n4);
            if (n17 > n16) {
                n16 = n17;
            }
            if ((n17 = Mipmap.computeLog(n5)) > n16) {
                n16 = n17;
            }
            if (!Mipmap.isLegalLevels(n8, n9, n10, n16 += n8)) {
                int n18 = 100901;
                return n18;
            }
            int n19 = BuildMipmap.gluBuild3DMipmapLevelsCore(gL, n, n2, n3, n4, n5, n3, n4, n5, n6, n7, n8, n9, n10, byteBuffer);
            return n19;
        }
        finally {
            byteBuffer.position(n11);
        }
    }
}

