/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PImage;

public class UP
extends PApplet {
    Background bg;
    Player player;
    ArrayList<Level> levels = new ArrayList();
    float gravity = 0.4f;
    boolean goLeft;
    boolean goRight = true;
    float vHeight = 0.0f;
    boolean isScreenMoving = false;
    int lastLevel;

    public void setup() {
        this.size(1000, 700);
        this.smooth();
        this.frameRate(60.0f);
        this.bg = new Background(this.loadImage("bg.png"), this.loadImage("Items/cloud1.png"));
        this.player = new Player(this.width / 2, 600.0f);
        int n = 0;
        while (n < 15) {
            if (n > 0) {
                float f = this.levels.get((int)(n - 1)).x + this.random(-600.0f, 600.0f);
                float f2 = this.levels.get((int)(n - 1)).y - this.random(50.0f, 150.0f);
                this.levels.add(new Level(f, f2, PApplet.parseInt((float)this.random(1.0f, 5.0f)), PApplet.parseInt((float)this.random(0.0f, 3.0f))));
                if (this.levels.get((int)n).x + this.levels.get((int)n).Width > (float)this.width) {
                    this.levels.get((int)n).x = (float)this.width - this.levels.get((int)n).Width;
                }
                if (this.levels.get((int)n).x < 0.0f) {
                    this.levels.get((int)n).x = 0.0f;
                }
            } else {
                this.levels.add(new Level(this.width / 2 - 100, this.height - 100, PApplet.parseInt((float)this.random(1.0f, 5.0f)), PApplet.parseInt((float)this.random(0.0f, 3.0f))));
            }
            ++n;
        }
        this.lastLevel = this.levels.size() - 1;
    }

    public void draw() {
        this.bg.draw();
        if (this.vHeight < 0.0f) {
            this.vHeight = 0.0f;
        }
        if (!this.keyPressed) {
            this.player.speedx = 0.0f;
        }
        if (this.goLeft) {
            this.player.direction = 0;
            this.player.speedx = -5.0f;
        }
        if (this.goRight) {
            this.player.direction = 1;
            this.player.speedx = 5.0f;
        }
        if (this.player.x + this.player.Width > (float)this.width) {
            this.goLeft = true;
            this.goRight = false;
        }
        if (this.player.x < 0.0f) {
            this.goLeft = false;
            this.goRight = true;
        }
        if (this.player.currentAt != -1 && this.player.state != 2) {
            if (this.player.x + this.player.Width > this.levels.get((int)this.player.currentAt).x + this.levels.get((int)this.player.currentAt).Width) {
                this.goLeft = true;
                this.goRight = false;
            }
            if (this.player.x < this.levels.get((int)this.player.currentAt).x) {
                this.goLeft = false;
                this.goRight = true;
            }
        }
        if (this.player.isFalling) {
            this.player.speedy += this.gravity;
            if (this.player.speedy > 5.0f) {
                this.player.speedy = 4.9f;
            }
        }
        int n = 0;
        while (n < this.levels.size()) {
            this.levels.get(n).draw();
            if (this.player.x + this.player.Width - 20.0f >= this.levels.get((int)n).x && this.player.x + 20.0f <= this.levels.get((int)n).x + this.levels.get((int)n).Width && UP.abs((float)(this.player.y + this.player.Height - this.levels.get((int)n).y)) < 5.0f && this.player.speedy > 0.0f) {
                this.player.y = this.levels.get((int)n).y - this.player.Height + 1.0f;
                this.player.speedy = 0.0f;
                this.player.isFalling = false;
                this.player.currentAt = n;
                if (this.player.currentAt != -1) {
                    switch (this.levels.get((int)this.player.currentAt).type) {
                        case 0: {
                            this.player.speedx *= 1.0f;
                            break;
                        }
                        case 1: {
                            this.player.speedx *= 0.5f;
                            break;
                        }
                        case 2: {
                            this.player.speedx *= 1.5f;
                        }
                    }
                } else {
                    this.player.isFalling = true;
                }
            }
            int n2 = 0;
            while (n2 < this.levels.size()) {
                if (this.isScreenMoving) {
                    if (this.player.speedy < 0.0f) {
                        this.levels.get((int)n2).speedy = -this.player.speedy;
                        this.vHeight += this.levels.get((int)n2).speedy;
                    }
                } else {
                    this.levels.get((int)n2).speedy = 0.0f;
                }
                ++n2;
            }
            ++n;
        }
        if (this.player.y + this.player.Height + 5.0f > (float)this.height && this.player.speedy > 0.0f && this.vHeight == 0.0f) {
            this.player.y = (float)(this.height - 5) - this.player.Height + 1.0f;
            this.player.speedy = 0.0f;
            this.player.currentAt = -1;
        } else {
            this.player.isFalling = true;
        }
        this.player.draw();
        this.fill(0);
        this.text("Score:" + PApplet.parseInt((float)(this.vHeight / 1000.0f)), this.width / 2, 20.0f);
    }

    public void keyPressed() {
        switch (this.keyCode) {
            case 32: {
                if (!(this.player.power < 100.0f)) break;
                this.player.power += 15.0f;
            }
        }
    }

    public void keyReleased() {
        switch (this.keyCode) {
            case 32: {
                if (this.player.state == 2) break;
                this.player.speedy = -20.0f * (this.player.power / 100.0f);
                this.player.power = 0.0f;
            }
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"UP"};
        if (stringArray != null) {
            PApplet.main((String[])UP.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }

    class Background {
        PImage tiles;
        PImage cloudTexture;
        ArrayList<Cloud> clouds = new ArrayList();
        int maxClouds = 10;

        Background(PImage pImage, PImage pImage2) {
            this.tiles = pImage;
            this.cloudTexture = pImage2;
            int n = 0;
            while (n < this.maxClouds) {
                this.clouds.add(new Cloud(this.cloudTexture, UP.this.random(0.0f, UP.this.width), 200.0f, 2.0f));
                ++n;
            }
        }

        public void draw() {
            int n = 0;
            while (n < UP.this.width) {
                int n2 = 0;
                while (n2 < UP.this.height) {
                    UP.this.image(this.tiles, n, n2, 128.0f, 128.0f);
                    n2 += 128;
                }
                n += 128;
            }
            n = 0;
            while (n < this.maxClouds) {
                this.clouds.get(n).draw();
                ++n;
            }
        }

        class Cloud {
            PImage texture;
            float x;
            float y;
            float speed;

            Cloud(PImage pImage, float f, float f2, float f3) {
                this.x = f + UP.this.random(-100.0f, 100.0f);
                this.y = f2 + UP.this.random(-100.0f, 100.0f);
                this.speed = f3 + UP.this.random(-1.0f, 1.0f) + UP.this.noise(((Background)Background.this).UP.this.vHeight);
                this.texture = pImage;
            }

            public void draw() {
                this.x += this.speed;
                if (this.x - 150.0f > (float)((Background)Background.this).UP.this.width) {
                    this.x = UP.this.random(-400.0f, -200.0f);
                }
                UP.this.tint(255, 180.0f);
                UP.this.image(this.texture, this.x, this.y, 128.0f, 71.0f);
            }
        }
    }

    class Level {
        ArrayList<PImage> images = new ArrayList();
        float x;
        float y;
        float leng;
        int type;
        float Width;
        float Height;
        int brickSize = 50;
        float speedy;

        Level(float f, float f2, float f3, int n) {
            this.x = f;
            this.y = f2;
            this.leng = f3;
            this.type = n;
            switch (this.type) {
                case 0: {
                    this.images.add(UP.this.loadImage("Tiles/grassLeft.png"));
                    this.images.add(UP.this.loadImage("Tiles/grassMid.png"));
                    this.images.add(UP.this.loadImage("Tiles/grassRight.png"));
                    this.images.add(UP.this.loadImage("items/plant.png"));
                    break;
                }
                case 1: {
                    this.images.add(UP.this.loadImage("Tiles/sandLeft.png"));
                    this.images.add(UP.this.loadImage("Tiles/sandMid.png"));
                    this.images.add(UP.this.loadImage("Tiles/sandRight.png"));
                    this.images.add(UP.this.loadImage("items/cactus.png"));
                    break;
                }
                case 2: {
                    this.images.add(UP.this.loadImage("Tiles/snowLeft.png"));
                    this.images.add(UP.this.loadImage("Tiles/snowMid.png"));
                    this.images.add(UP.this.loadImage("Tiles/snowRight.png"));
                    this.images.add(UP.this.loadImage("items/snowhill.png"));
                }
            }
            this.Width = (float)(this.brickSize * 2) + this.leng * (float)this.brickSize;
            this.Height = this.brickSize;
        }

        public void draw() {
            this.y += this.speedy;
            if (this.y > (float)(UP.this.height + 400)) {
                this.x = UP.this.levels.get((int)UP.this.lastLevel).x + UP.this.random(-600.0f, 600.0f);
                this.y = UP.this.levels.get((int)UP.this.lastLevel).y - UP.this.random(50.0f, 150.0f);
                this.leng = PApplet.parseInt((float)UP.this.random(1.0f, 5.0f));
                this.Width = (float)(this.brickSize * 2) + this.leng * (float)this.brickSize;
                this.Height = this.brickSize;
                if (this.x + this.Width > (float)UP.this.width) {
                    this.x = (float)UP.this.width - this.Width;
                }
                if (this.x < 0.0f) {
                    this.x = 0.0f;
                }
                this.type = PApplet.parseInt((float)UP.this.random(0.0f, 3.0f));
                this.images = new ArrayList();
                switch (this.type) {
                    case 0: {
                        this.images.add(UP.this.loadImage("Tiles/grassLeft.png"));
                        this.images.add(UP.this.loadImage("Tiles/grassMid.png"));
                        this.images.add(UP.this.loadImage("Tiles/grassRight.png"));
                        this.images.add(UP.this.loadImage("items/plant.png"));
                        break;
                    }
                    case 1: {
                        this.images.add(UP.this.loadImage("Tiles/sandLeft.png"));
                        this.images.add(UP.this.loadImage("Tiles/sandMid.png"));
                        this.images.add(UP.this.loadImage("Tiles/sandRight.png"));
                        this.images.add(UP.this.loadImage("items/cactus.png"));
                        break;
                    }
                    case 2: {
                        this.images.add(UP.this.loadImage("Tiles/snowLeft.png"));
                        this.images.add(UP.this.loadImage("Tiles/snowMid.png"));
                        this.images.add(UP.this.loadImage("Tiles/snowRight.png"));
                        this.images.add(UP.this.loadImage("items/snowhill.png"));
                    }
                }
                UP.this.lastLevel = UP.this.lastLevel >= UP.this.levels.size() - 1 ? 0 : ++UP.this.lastLevel;
            }
            UP.this.tint(255, 255.0f);
            UP.this.image(this.images.get(0), this.x, this.y, this.brickSize, this.brickSize);
            int n = 0;
            while ((float)n < this.leng) {
                UP.this.image(this.images.get(1), this.x + (float)this.brickSize + (float)(this.brickSize * n), this.y, this.brickSize, this.brickSize);
                ++n;
            }
            if (this.x % 5.0f == 0.0f) {
                UP.this.image(this.images.get(3), this.x + (float)this.brickSize, this.y - (float)this.images.get((int)3).height);
            }
            UP.this.image(this.images.get(2), this.x + this.Width - (float)this.brickSize, this.y, this.brickSize, this.brickSize);
        }
    }

    class Player {
        float x;
        float y;
        float speedx;
        float speedy;
        ArrayList<PImage> frames = new ArrayList();
        float frameSpeed = 0.3f;
        float currentFrame = 4.0f;
        final int STAND = 1;
        final int JUMP = 2;
        final int DUCK = 3;
        final int HURT = 4;
        final int WALKING = 5;
        final int DLEFT = 0;
        final int DRIGHT = 1;
        int direction = 0;
        int state = 1;
        float Height;
        float Width;
        boolean isFalling = true;
        int currentAt = -1;
        float power = 0.0f;

        Player(float f, float f2) {
            this.x = f;
            this.y = f2;
            this.frames.add(UP.this.loadImage("Player/p1_front.png"));
            this.frames.add(UP.this.loadImage("Player/p1_jump.png"));
            this.frames.add(UP.this.loadImage("Player/p1_duck.png"));
            this.frames.add(UP.this.loadImage("Player/p1_hurt.png"));
            this.frames.add(UP.this.loadImage("Player/p1_walk/PNG/p1_walk01.png"));
            this.frames.add(UP.this.loadImage("Player/p1_walk/PNG/p1_walk02.png"));
            this.frames.add(UP.this.loadImage("Player/p1_walk/PNG/p1_walk03.png"));
            this.frames.add(UP.this.loadImage("Player/p1_walk/PNG/p1_walk04.png"));
            this.frames.add(UP.this.loadImage("Player/p1_walk/PNG/p1_walk05.png"));
            this.frames.add(UP.this.loadImage("Player/p1_walk/PNG/p1_walk06.png"));
            this.frames.add(UP.this.loadImage("Player/p1_walk/PNG/p1_walk07.png"));
            this.frames.add(UP.this.loadImage("Player/p1_walk/PNG/p1_walk08.png"));
            this.frames.add(UP.this.loadImage("Player/p1_walk/PNG/p1_walk09.png"));
            this.frames.add(UP.this.loadImage("Player/p1_walk/PNG/p1_walk10.png"));
            this.frames.add(UP.this.loadImage("Player/p1_walk/PNG/p1_walk11.png"));
            this.Height = this.frames.get((int)0).height;
            this.Width = this.frames.get((int)0).width;
        }

        public void stateChange(int n) {
            this.state = n;
            if (n != 5) {
                this.currentFrame = 4.0f;
            }
        }

        public void draw() {
            this.x += this.speedx;
            if (this.y < (float)(UP.this.height / 2)) {
                UP.this.isScreenMoving = true;
                if (this.speedy > 0.0f) {
                    this.y += this.speedy;
                }
            } else {
                this.y += this.speedy;
                UP.this.isScreenMoving = false;
            }
            this.frameSpeed = UP.abs((float)(this.speedx / 10.0f));
            if (UP.abs((float)this.speedx) == 0.0f && UP.abs((float)this.speedy) == 0.0f) {
                this.state = !UP.this.keyPressed ? 1 : 3;
            } else if (UP.abs((float)this.speedy) == 0.0f) {
                this.state = 5;
            } else if (this.isFalling) {
                this.state = 2;
            }
            UP.this.translate(0.0f, 0.0f);
            UP.this.tint(255, 255.0f);
            switch (this.state) {
                case 1: {
                    UP.this.image(this.frames.get(0), this.x, this.y);
                    break;
                }
                case 2: {
                    if (this.direction == 0) {
                        UP.this.pushMatrix();
                        UP.this.scale(-1.0f, 1.0f);
                        UP.this.image(this.frames.get(1), (float)(-this.frames.get((int)PApplet.parseInt((float)1.0f)).width) - this.x, this.y);
                        UP.this.popMatrix();
                        break;
                    }
                    UP.this.image(this.frames.get(1), this.x, this.y);
                    break;
                }
                case 5: {
                    this.currentFrame += this.frameSpeed;
                    if (this.currentFrame > 14.0f) {
                        this.currentFrame = 4.0f;
                    }
                    if (this.direction == 0) {
                        UP.this.pushMatrix();
                        UP.this.scale(-1.0f, 1.0f);
                        UP.this.image(this.frames.get(PApplet.parseInt((float)this.currentFrame)), (float)(-this.frames.get((int)PApplet.parseInt((float)this.currentFrame)).width) - this.x, this.y);
                        UP.this.popMatrix();
                        break;
                    }
                    UP.this.image(this.frames.get(PApplet.parseInt((float)this.currentFrame)), this.x, this.y);
                    break;
                }
                case 3: {
                    if (this.direction == 0) {
                        UP.this.pushMatrix();
                        UP.this.scale(-1.0f, 1.0f);
                        UP.this.image(this.frames.get(2), (float)(-this.frames.get((int)PApplet.parseInt((float)2.0f)).width) - this.x, this.y + this.Height / 2.0f - 25.0f);
                        UP.this.popMatrix();
                        break;
                    }
                    UP.this.image(this.frames.get(2), this.x, this.y + this.Height / 2.0f - 25.0f);
                    break;
                }
                case 4: {
                    if (this.direction == 0) {
                        UP.this.pushMatrix();
                        UP.this.scale(-1.0f, 1.0f);
                        UP.this.image(this.frames.get(3), (float)(-this.frames.get((int)PApplet.parseInt((float)3.0f)).width) - this.x, this.y);
                        UP.this.popMatrix();
                        break;
                    }
                    UP.this.image(this.frames.get(3), this.x, this.y);
                }
            }
            UP.this.stroke(0);
            UP.this.fill(255.0f, 0.0f, 0.0f, 255.0f);
            UP.this.rectMode(1);
            UP.this.rect(this.x + this.Width + 10.0f, this.y + this.Height - 20.0f, this.x + this.Width + 30.0f, this.y + 20.0f);
            UP.this.noStroke();
            UP.this.fill(255, 255.0f);
            UP.this.rectMode(1);
            UP.this.rect(this.x + this.Width + 11.0f, this.y + 21.0f, this.x + this.Width + 29.0f, this.y + this.Height - 17.0f - (this.y + this.Height - 19.0f - (this.y + 19.0f)) * (this.power / 100.0f));
        }
    }
}

