class Background {
  PImage tiles;
  PImage cloudTexture;
  ArrayList<Cloud> clouds = new ArrayList<Cloud>();
  int maxClouds = 10;

  class Cloud {

    PImage texture;
    float x, y;
    float speed;
    
    // init clouds

    Cloud(PImage temptexture, float tempx, float tempy, float tempspeed) {

      x = tempx + random(-100,100);
      y = tempy + random(-100, 100);
      speed = tempspeed + random(-1,1) + noise(vHeight);
      texture = temptexture;
    }

    void draw() {

      x += speed;

      if (x - 150 > width) {

        x = random(-400, -200);
      }



      tint(255, 180);
      image(texture, x, y, 128, 71);
    }
  }


  Background(PImage tempTiles, PImage tempCloud) {

    tiles = tempTiles;
    cloudTexture = tempCloud;

    for (int i=0;i<maxClouds; i++) {

      clouds.add(new Cloud(cloudTexture, random(0, width), 200, 2));
    }
  }
  
  // draw background

  void draw() {

    for (int ix= 0; ix < width;ix+= 128) {

      for (int iy= 0; iy< height;iy+= 128) {

        image(tiles, ix, iy, 128, 128);
      }
    }

    for (int i=0;i<maxClouds; i++) {

      clouds.get(i).draw();
    }
  }
}

