class Player {
  
  // varibles

  float x, y;
  float speedx, speedy;
  ArrayList<PImage> frames = new ArrayList<PImage>();

  float frameSpeed = 0.3;
  float currentFrame = 4;

  final int STAND = 1;
  final int JUMP = 2;
  final int DUCK = 3;
  final int HURT = 4;
  final int WALKING = 5;
  final int DLEFT = 0;
  final int DRIGHT = 1;

  int direction = DLEFT;
  int state = 1;

  float Height, Width;

  boolean isFalling = true;

  int currentAt = -1;

  float power = 0;



  Player(float tx, float ty) {
    
    // init images

    x = tx;
    y = ty;

    frames.add(loadImage("Player/p1_front.png"));
    frames.add(loadImage("Player/p1_jump.png"));
    frames.add(loadImage("Player/p1_duck.png"));
    frames.add(loadImage("Player/p1_hurt.png"));
    frames.add(loadImage("Player/p1_walk/PNG/p1_walk01.png"));
    frames.add(loadImage("Player/p1_walk/PNG/p1_walk02.png"));
    frames.add(loadImage("Player/p1_walk/PNG/p1_walk03.png"));
    frames.add(loadImage("Player/p1_walk/PNG/p1_walk04.png"));
    frames.add(loadImage("Player/p1_walk/PNG/p1_walk05.png"));
    frames.add(loadImage("Player/p1_walk/PNG/p1_walk06.png"));
    frames.add(loadImage("Player/p1_walk/PNG/p1_walk07.png"));
    frames.add(loadImage("Player/p1_walk/PNG/p1_walk08.png"));
    frames.add(loadImage("Player/p1_walk/PNG/p1_walk09.png"));
    frames.add(loadImage("Player/p1_walk/PNG/p1_walk10.png"));
    frames.add(loadImage("Player/p1_walk/PNG/p1_walk11.png"));

    Height = frames.get(0).height;
    Width = frames.get(0).width;
  }

  void stateChange(int newState) {
    
    // change character's state

    state = newState;

    if (newState != WALKING) {
      currentFrame = 4;
    }
  }

  void draw() {
    
    // draw

    x += speedx;

    // check whether need to move the screen

    if (y < height / 2 ) {

      isScreenMoving = true;
      if (speedy > 0) y += speedy;
    } 
    else {

      y += speedy;
      isScreenMoving = false;
    }
    
    // change the speed of animation

    frameSpeed = abs(speedx / 10);

    if (abs(speedx) == 0 && abs(speedy) ==0) {

      if (!keyPressed) {
        state = STAND;
      } 
      else {
        state = DUCK;
      }
    } 
    else if (abs(speedy) == 0) {

      state = WALKING;
    } 
    else {

      if (isFalling) {
        state = JUMP;
      }
    }
    
    // draw

    translate(0, 0);
    tint(255, 255);

    switch(state) {

    case STAND:

      image(frames.get(0), x, y);
      break;
    case JUMP:

      if (direction == DLEFT) {
        pushMatrix();
        scale(-1, 1);
        image(frames.get(1), -frames.get(int(1)).width - x, y);
        popMatrix();
      } 
      else {

        image(frames.get(1), x, y);
      }
      break;

    case WALKING:

      currentFrame += frameSpeed;

      if (currentFrame > 14) {
        currentFrame = 4;
      }

      if (direction == DLEFT) {

        pushMatrix();
        scale(-1, 1);
        image(frames.get(int(currentFrame)), -frames.get(int(currentFrame)).width - x, y);
        popMatrix();
      } 
      else {
        image(frames.get(int(currentFrame)), x, y);
      }

      break;
    case DUCK:


      if (direction == DLEFT) {
        pushMatrix();
        scale(-1, 1);
        image(frames.get(2), -frames.get(int(2)).width - x, y + Height / 2 - 25);
        popMatrix();
      } 
      else {
        image(frames.get(2), x, y + Height / 2 - 25);
      }
      break;

    case HURT:

      if (direction == DLEFT) {
        pushMatrix();
        scale(-1, 1);
        image(frames.get(3), -frames.get(int(3)).width - x, y);
        popMatrix();
      } 
      else {
        image(frames.get(3), x, y);
      }

      break;
    }

    // draw the frame of power bar

    stroke(0);
    fill(255,0,0, 255);
    rectMode(CORNERS);
    rect(x + Width + 10, y + Height - 20, x + Width + 30, y + 20);

    // draw power bar

    noStroke();
    fill(255, 255);
    rectMode(CORNERS);
    rect(x + Width + 11, y + 21, x + Width + 29, (y + Height - 17) - ((y + Height - 19) - (y + 19 ))  * (power / 100));
  }
}

