import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class UP extends PApplet {

/*

 ===============================================================================
 =UP! By Sida Li=
 =Media Computation Assignment 4=
 
 Use Spacebar to jump
 get the highest score as you can!
 
 
 ===============================================================================
 
 ###############################################################################
 Graphics by:
 
 Platformer Art Deluxe (Pixel) by Kenney Vleugels (www.kenney.nl)
 
 ------------------------------
 
 License (CC0)
 http://creativecommons.org/publicdomain/zero/1.0/
 
 You may use these graphics in personal and commercial projects.
 Credit (Kenney or www.kenney.nl) would be nice but is not mandatory.
 
 ###############################################################################
 
 */

// Declear varibles

Background bg;
Player player;
ArrayList<Level> levels = new ArrayList<Level>();

// W = 87,A = 65,S = 83,D = 68,Space = 32 as controls

float gravity = 0.4f;
boolean goLeft;
boolean goRight = true;
float vHeight = 0;
boolean isScreenMoving = false;
int lastLevel;

public void setup() {

  size(1000, 700);

  smooth();
  frameRate(60);

  // init classes

  bg = new Background(loadImage("bg.png"), loadImage("Items/cloud1.png"));
  player = new Player(width / 2, 600);
  
  // Create levels

  for (int i=0;i< 15; i++) {

    if (i>0) {

      float tempX, tempY;
      tempX = levels.get(i - 1).x + random(-600, 600);
      tempY = levels.get(i - 1).y - random(50, 150);

      levels.add(new Level( tempX, tempY, PApplet.parseInt(random(1, 5)), PApplet.parseInt(random(0, 3))));

      if (levels.get(i).x + levels.get(i).Width > width) levels.get(i).x = width - levels.get(i).Width;
      if (levels.get(i).x < 0) levels.get(i).x = 0;
    } 
    else {
      levels.add(new Level(width / 2 - 100, height - 100, PApplet.parseInt(random(1, 5)), PApplet.parseInt(random(0, 3))));
    }
  }

  lastLevel = levels.size() - 1;
}

public void draw() {

  // draw


  bg.draw();

  if (vHeight < 0) {

    vHeight = 0;
  }

  if (!keyPressed) {

    player.speedx = 0;
  }
  
  // make chararcter move

  if (goLeft) {
    player.direction = 0;
    player.speedx = -5;
  }

  if (goRight) {

    player.direction = 1;
    player.speedx = 5;
  }

  if (player.x + player.Width> width ) {
    goLeft = true;
    goRight = false;
  }

  if (player.x < 0) {
    goLeft = false;
    goRight = true;
  }

  if (player.currentAt != -1 && player.state !=2) {
    if (player.x + player.Width >  levels.get(player.currentAt).x +  levels.get(player.currentAt).Width) {
      goLeft = true;
      goRight = false;
    }

    if ( player.x <  levels.get(player.currentAt).x ) {
      goLeft = false;
      goRight = true;
    }
  }

  // Falling

  if (player.isFalling) {
    player.speedy += gravity;
    if (player.speedy > 5) player.speedy = 4.9f;
  }
  
  // Check if character is on the ground

  for (int i = 0; i< levels.size();i++) {
    levels.get(i).draw();

    if ((player.x + player.Width - 20 >= levels.get(i).x && player.x  + 20 <= levels.get(i).x + levels.get(i).Width)
      && (abs(player.y + player.Height - levels.get(i).y) < 5)
      && player.speedy > 0) {

      player.y = levels.get(i).y - player.Height + 1;
      player.speedy = 0;
      player.isFalling = false;

      player.currentAt = i;
      
      // change the movement speed

      if (player.currentAt != -1) {
        switch(levels.get(player.currentAt).type) {
        case 0:
          player.speedx = player.speedx * 1;
          break;
        case 1:
          player.speedx = player.speedx * 0.5f;
          break;
        case 2:
          player.speedx = player.speedx * 1.5f;
          break;
        }

      } 
      else {
        player.isFalling= true;
      }
    }
    
    // move the screen

    for (int l=0;l < levels.size(); l++) {

      if (isScreenMoving) {

        if (player.speedy < 0) {
          levels.get(l).speedy = - player.speedy;
          vHeight += levels.get(l).speedy;
        }
      } 
      else {
        levels.get(l).speedy = 0;
      }
    }
  }

  // Character is on the ground

  if (player.y + player.Height + 5 > height && player.speedy > 0 && vHeight == 0) {

    player.y= height - 5 - player.Height + 1;
    player.speedy = 0;
    player.currentAt = -1;
  } 
  else {
    player.isFalling= true;
  }
  
  // draw player

  player.draw();

  // Draw the score

  fill(0);
  text("Score:" + PApplet.parseInt(vHeight / 1000), width / 2, 20);
}

public void keyPressed() {

  switch(keyCode) {

  case 32:

    if (player.power < 100) {
      player.power += 15;
    }

    break;
  }
}

public void keyReleased() {
  
  // jumnp

  switch(keyCode) {

  case 32:

    if (player.state != 2) {
      player.speedy = -20 * (player.power / 100);
      player.power = 0;
    }

    break;
  }
}

class Background {
  PImage tiles;
  PImage cloudTexture;
  ArrayList<Cloud> clouds = new ArrayList<Cloud>();
  int maxClouds = 10;

  class Cloud {

    PImage texture;
    float x, y;
    float speed;
    
    // init clouds

    Cloud(PImage temptexture, float tempx, float tempy, float tempspeed) {

      x = tempx + random(-100,100);
      y = tempy + random(-100, 100);
      speed = tempspeed + random(-1,1) + noise(vHeight);
      texture = temptexture;
    }

    public void draw() {

      x += speed;

      if (x - 150 > width) {

        x = random(-400, -200);
      }



      tint(255, 180);
      image(texture, x, y, 128, 71);
    }
  }


  Background(PImage tempTiles, PImage tempCloud) {

    tiles = tempTiles;
    cloudTexture = tempCloud;

    for (int i=0;i<maxClouds; i++) {

      clouds.add(new Cloud(cloudTexture, random(0, width), 200, 2));
    }
  }
  
  // draw background

  public void draw() {

    for (int ix= 0; ix < width;ix+= 128) {

      for (int iy= 0; iy< height;iy+= 128) {

        image(tiles, ix, iy, 128, 128);
      }
    }

    for (int i=0;i<maxClouds; i++) {

      clouds.get(i).draw();
    }
  }
}



class Level {

  ArrayList<PImage> images = new ArrayList<PImage>();

  // init varibles

  float x, y, leng;
  int type;
  float Width, Height;
  int brickSize = 50;
  float speedy;

  Level(float tempx, float tempy, float templeng, int ttype) {

    // init level

    x = tempx;
    y = tempy;
    leng = templeng;

    type = ttype;

    switch(type) {

    // import images

    case 0:
      images.add(loadImage("Tiles/grassLeft.png"));
      images.add(loadImage("Tiles/grassMid.png"));
      images.add(loadImage("Tiles/grassRight.png"));
      images.add(loadImage("items/plant.png"));
      break;

    case 1:
      images.add(loadImage("Tiles/sandLeft.png"));
      images.add(loadImage("Tiles/sandMid.png"));
      images.add(loadImage("Tiles/sandRight.png"));
      images.add(loadImage("items/cactus.png"));
      break;

    case 2:
      images.add(loadImage("Tiles/snowLeft.png"));
      images.add(loadImage("Tiles/snowMid.png"));
      images.add(loadImage("Tiles/snowRight.png"));
      images.add(loadImage("items/snowhill.png"));
      break;
    }



    Width = brickSize * 2 + leng * brickSize;
    Height = brickSize;
  }

  public void draw() {

    y += speedy;

    if (y > height + 400) {

      // spawn new level


      x = levels.get(lastLevel).x + random(-600, 600);
      y = levels.get(lastLevel).y - random(50, 150);
      leng = PApplet.parseInt(random(1, 5));

      Width = brickSize * 2 + leng * brickSize;
      Height = brickSize;

      if ( x + Width > width) x = width - Width;
      if (x < 0) x = 0;

      type = PApplet.parseInt(random(0, 3));

      images = new ArrayList<PImage>();

      switch(type) {

      case 0:
        images.add(loadImage("Tiles/grassLeft.png"));
        images.add(loadImage("Tiles/grassMid.png"));
        images.add(loadImage("Tiles/grassRight.png"));
        images.add(loadImage("items/plant.png"));
        break;

      case 1:
        images.add(loadImage("Tiles/sandLeft.png"));
        images.add(loadImage("Tiles/sandMid.png"));
        images.add(loadImage("Tiles/sandRight.png"));
        images.add(loadImage("items/cactus.png"));
        break;

      case 2:
        images.add(loadImage("Tiles/snowLeft.png"));
        images.add(loadImage("Tiles/snowMid.png"));
        images.add(loadImage("Tiles/snowRight.png"));
        images.add(loadImage("items/snowhill.png"));
        break;
      }



      if (lastLevel >= levels.size() - 1) {
        lastLevel = 0;
      } 
      else {
        lastLevel ++;
      }
    }

    // draw level

    tint(255, 255);

    image(images.get(0), x, y, brickSize, brickSize);

    for (int i = 0;i < leng;i++) {

      image(images.get(1), (x + brickSize) + brickSize * i, y, brickSize, brickSize);
    }
    
    if(x % 5 == 0){
      
      image(images.get(3), (x + brickSize) , y - images.get(3).height);
    }

    image(images.get(2), x + Width - brickSize, y, brickSize, brickSize);
  }
}

class Player {
  
  // varibles

  float x, y;
  float speedx, speedy;
  ArrayList<PImage> frames = new ArrayList<PImage>();

  float frameSpeed = 0.3f;
  float currentFrame = 4;

  final int STAND = 1;
  final int JUMP = 2;
  final int DUCK = 3;
  final int HURT = 4;
  final int WALKING = 5;
  final int DLEFT = 0;
  final int DRIGHT = 1;

  int direction = DLEFT;
  int state = 1;

  float Height, Width;

  boolean isFalling = true;

  int currentAt = -1;

  float power = 0;



  Player(float tx, float ty) {
    
    // init images

    x = tx;
    y = ty;

    frames.add(loadImage("Player/p1_front.png"));
    frames.add(loadImage("Player/p1_jump.png"));
    frames.add(loadImage("Player/p1_duck.png"));
    frames.add(loadImage("Player/p1_hurt.png"));
    frames.add(loadImage("Player/p1_walk/PNG/p1_walk01.png"));
    frames.add(loadImage("Player/p1_walk/PNG/p1_walk02.png"));
    frames.add(loadImage("Player/p1_walk/PNG/p1_walk03.png"));
    frames.add(loadImage("Player/p1_walk/PNG/p1_walk04.png"));
    frames.add(loadImage("Player/p1_walk/PNG/p1_walk05.png"));
    frames.add(loadImage("Player/p1_walk/PNG/p1_walk06.png"));
    frames.add(loadImage("Player/p1_walk/PNG/p1_walk07.png"));
    frames.add(loadImage("Player/p1_walk/PNG/p1_walk08.png"));
    frames.add(loadImage("Player/p1_walk/PNG/p1_walk09.png"));
    frames.add(loadImage("Player/p1_walk/PNG/p1_walk10.png"));
    frames.add(loadImage("Player/p1_walk/PNG/p1_walk11.png"));

    Height = frames.get(0).height;
    Width = frames.get(0).width;
  }

  public void stateChange(int newState) {
    
    // change character's state

    state = newState;

    if (newState != WALKING) {
      currentFrame = 4;
    }
  }

  public void draw() {
    
    // draw

    x += speedx;

    // check whether need to move the screen

    if (y < height / 2 ) {

      isScreenMoving = true;
      if (speedy > 0) y += speedy;
    } 
    else {

      y += speedy;
      isScreenMoving = false;
    }
    
    // change the speed of animation

    frameSpeed = abs(speedx / 10);

    if (abs(speedx) == 0 && abs(speedy) ==0) {

      if (!keyPressed) {
        state = STAND;
      } 
      else {
        state = DUCK;
      }
    } 
    else if (abs(speedy) == 0) {

      state = WALKING;
    } 
    else {

      if (isFalling) {
        state = JUMP;
      }
    }
    
    // draw

    translate(0, 0);
    tint(255, 255);

    switch(state) {

    case STAND:

      image(frames.get(0), x, y);
      break;
    case JUMP:

      if (direction == DLEFT) {
        pushMatrix();
        scale(-1, 1);
        image(frames.get(1), -frames.get(PApplet.parseInt(1)).width - x, y);
        popMatrix();
      } 
      else {

        image(frames.get(1), x, y);
      }
      break;

    case WALKING:

      currentFrame += frameSpeed;

      if (currentFrame > 14) {
        currentFrame = 4;
      }

      if (direction == DLEFT) {

        pushMatrix();
        scale(-1, 1);
        image(frames.get(PApplet.parseInt(currentFrame)), -frames.get(PApplet.parseInt(currentFrame)).width - x, y);
        popMatrix();
      } 
      else {
        image(frames.get(PApplet.parseInt(currentFrame)), x, y);
      }

      break;
    case DUCK:


      if (direction == DLEFT) {
        pushMatrix();
        scale(-1, 1);
        image(frames.get(2), -frames.get(PApplet.parseInt(2)).width - x, y + Height / 2 - 25);
        popMatrix();
      } 
      else {
        image(frames.get(2), x, y + Height / 2 - 25);
      }
      break;

    case HURT:

      if (direction == DLEFT) {
        pushMatrix();
        scale(-1, 1);
        image(frames.get(3), -frames.get(PApplet.parseInt(3)).width - x, y);
        popMatrix();
      } 
      else {
        image(frames.get(3), x, y);
      }

      break;
    }

    // draw the frame of power bar

    stroke(0);
    fill(255,0,0, 255);
    rectMode(CORNERS);
    rect(x + Width + 10, y + Height - 20, x + Width + 30, y + 20);

    // draw power bar

    noStroke();
    fill(255, 255);
    rectMode(CORNERS);
    rect(x + Width + 11, y + 21, x + Width + 29, (y + Height - 17) - ((y + Height - 19) - (y + 19 ))  * (power / 100));
  }
}

  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "UP" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
