/*

 ===============================================================================
 =UP! By Sida Li=
 =Media Computation Assignment 4=
 
 Use Spacebar to jump
 get the highest score as you can!
 
 
 ===============================================================================
 
 ###############################################################################
 Graphics by:
 
 Platformer Art Deluxe (Pixel) by Kenney Vleugels (www.kenney.nl)
 
 ------------------------------
 
 License (CC0)
 http://creativecommons.org/publicdomain/zero/1.0/
 
 You may use these graphics in personal and commercial projects.
 Credit (Kenney or www.kenney.nl) would be nice but is not mandatory.
 
 ###############################################################################
 
 */

// Declear varibles

Background bg;
Player player;
ArrayList<Level> levels = new ArrayList<Level>();

// W = 87,A = 65,S = 83,D = 68,Space = 32 as controls

float gravity = 0.4;
boolean goLeft;
boolean goRight = true;
float vHeight = 0;
boolean isScreenMoving = false;
int lastLevel;

void setup() {

  size(1000, 700);

  smooth();
  frameRate(60);

  // init classes

  bg = new Background(loadImage("bg.png"), loadImage("Items/cloud1.png"));
  player = new Player(width / 2, 600);
  
  // Create levels

  for (int i=0;i< 15; i++) {

    if (i>0) {

      float tempX, tempY;
      tempX = levels.get(i - 1).x + random(-600, 600);
      tempY = levels.get(i - 1).y - random(50, 150);

      levels.add(new Level( tempX, tempY, int(random(1, 5)), int(random(0, 3))));

      if (levels.get(i).x + levels.get(i).Width > width) levels.get(i).x = width - levels.get(i).Width;
      if (levels.get(i).x < 0) levels.get(i).x = 0;
    } 
    else {
      levels.add(new Level(width / 2 - 100, height - 100, int(random(1, 5)), int(random(0, 3))));
    }
  }

  lastLevel = levels.size() - 1;
}

void draw() {

  // draw


  bg.draw();

  if (vHeight < 0) {

    vHeight = 0;
  }

  if (!keyPressed) {

    player.speedx = 0;
  }
  
  // make chararcter move

  if (goLeft) {
    player.direction = 0;
    player.speedx = -5;
  }

  if (goRight) {

    player.direction = 1;
    player.speedx = 5;
  }

  if (player.x + player.Width> width ) {
    goLeft = true;
    goRight = false;
  }

  if (player.x < 0) {
    goLeft = false;
    goRight = true;
  }

  if (player.currentAt != -1 && player.state !=2) {
    if (player.x + player.Width >  levels.get(player.currentAt).x +  levels.get(player.currentAt).Width) {
      goLeft = true;
      goRight = false;
    }

    if ( player.x <  levels.get(player.currentAt).x ) {
      goLeft = false;
      goRight = true;
    }
  }

  // Falling

  if (player.isFalling) {
    player.speedy += gravity;
    if (player.speedy > 5) player.speedy = 4.9;
  }
  
  // Check if character is on the ground

  for (int i = 0; i< levels.size();i++) {
    levels.get(i).draw();

    if ((player.x + player.Width - 20 >= levels.get(i).x && player.x  + 20 <= levels.get(i).x + levels.get(i).Width)
      && (abs(player.y + player.Height - levels.get(i).y) < 5)
      && player.speedy > 0) {

      player.y = levels.get(i).y - player.Height + 1;
      player.speedy = 0;
      player.isFalling = false;

      player.currentAt = i;
      
      // change the movement speed

      if (player.currentAt != -1) {
        switch(levels.get(player.currentAt).type) {
        case 0:
          player.speedx = player.speedx * 1;
          break;
        case 1:
          player.speedx = player.speedx * 0.5;
          break;
        case 2:
          player.speedx = player.speedx * 1.5;
          break;
        }

      } 
      else {
        player.isFalling= true;
      }
    }
    
    // move the screen

    for (int l=0;l < levels.size(); l++) {

      if (isScreenMoving) {

        if (player.speedy < 0) {
          levels.get(l).speedy = - player.speedy;
          vHeight += levels.get(l).speedy;
        }
      } 
      else {
        levels.get(l).speedy = 0;
      }
    }
  }

  // Character is on the ground

  if (player.y + player.Height + 5 > height && player.speedy > 0 && vHeight == 0) {

    player.y= height - 5 - player.Height + 1;
    player.speedy = 0;
    player.currentAt = -1;
  } 
  else {
    player.isFalling= true;
  }
  
  // draw player

  player.draw();

  // Draw the score

  fill(0);
  text("Score:" + int(vHeight / 1000), width / 2, 20);
}

void keyPressed() {

  switch(keyCode) {

  case 32:

    if (player.power < 100) {
      player.power += 15;
    }

    break;
  }
}

void keyReleased() {
  
  // jumnp

  switch(keyCode) {

  case 32:

    if (player.state != 2) {
      player.speedy = -20 * (player.power / 100);
      player.power = 0;
    }

    break;
  }
}

